require "TimedActions/ISBaseTimedAction"
require "ISUI/ISFirearmRadialMenu"

--------------------------------------------
---------- Gunfighter Radial Menu ----------
--------------------------------------------

function ISFirearmRadialMenu:getWeapon()
	local weapon = self.character:getPrimaryHandItem()
	if not weapon then return nil end
	if not instanceof(weapon, "HandWeapon") then return nil end
	if not weapon:isAimedFirearm() then return nil end 			-- GunFighter Radial Menu -- Changed weapon:isRanged() to weapon:isAimedFirearm() to enable for Melee Mode.
	return weapon
end

local ISFirearmRadialMenu_fillMenu_old = ISFirearmRadialMenu.fillMenu
function ISFirearmRadialMenu:fillMenu(submenu)
	
	local menu = getPlayerRadialMenu(self.playerNum)
	menu:clear()

	ISFirearmRadialMenu_fillMenu_old(self)

	local Gun = self:getWeapon()
	local GunisRanged = Gun:isRanged()
	local GunType = Gun:getType()
	local MagType = Gun:getMagazineType()
	local MagTypeExt = Gun:getModData().ExtMagType
	local MagTypeDrum = Gun:getModData().DrumMagType
	local GunAmmoType = Gun:getAmmoType()
	local GunTrajectory = Gun:getModData().Trajectory
	local GunIntegral = Gun:getModData().Integral
	local GunMelee = Gun:getModData().Melee
	local GunSling = Gun:getSling()
	local GunFold = Gun:getModData().Fold
	local GunStock = Gun:getStock()
	local GunLight = Gun:getModData().LightOn

	ISFirearmRadialMenu.main = {}
	
	-- Change Magazine Type
	if GunisRanged and (MagTypeExt or MagTypeDrum) then
		local result = InventoryItemFactory.CreateItem(GunType)
		local MagTypeStd = result:getMagazineType()
		ISFirearmRadialMenu.main["CMagType"] = {}
		if MagType == MagTypeStd then
			ISFirearmRadialMenu.main["CMagType"].name = getText("IGUI_GFR_MagType") .. '\n' .. '[' .. getText("IGUI_GFR_MagTypeStd") .. ']'
		elseif MagType == MagTypeExt then
			ISFirearmRadialMenu.main["CMagType"].name = getText("IGUI_GFR_MagType") .. '\n' .. '[' .. getText("IGUI_GFR_MagTypeExt") .. ']'
		elseif MagType == MagTypeDrum then
			ISFirearmRadialMenu.main["CMagType"].name = getText("IGUI_GFR_MagType") .. '\n' .. '[' .. getText("IGUI_GFR_MagTypeDrum") .. ']'
		end
		ISFirearmRadialMenu.main["CMagType"].icons = getTexture("media/ui/GFR_MagType.png")
		ISFirearmRadialMenu.main["CMagType"].subMenu = {}
		-- To Standard
		if MagType ~= MagTypeStd then
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeStd"] = {}
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeStd"].name = getText("IGUI_GFR_MagTypeStd")
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeStd"].icons = getTexture("media/ui/GFR_MagTypeStd.png")
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeStd"].functions = self.GFRMSimKeyPressMagtype
			if MagType == MagTypeExt then
				ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeStd"].arguments = "MAG_TYPE_2"
			elseif MagType == MagTypeDrum then
				ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeStd"].arguments = "MAG_TYPE_1"
			end
		end
		-- To Extended -- and self.character:getInventory():contains(MagTypeExt) 
		if MagTypeExt and MagType ~= MagTypeExt then
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeExt"] = {}
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeExt"].name = getText("IGUI_GFR_MagTypeExt")
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeExt"].icons = getTexture("media/ui/GFR_MagTypeExt.png")
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeExt"].functions = self.GFRMSimKeyPressMagtype
			if MagType == MagTypeStd then
				ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeExt"].arguments = "MAG_TYPE_1"
			elseif MagType == MagTypeDrum then
				ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeExt"].arguments = "MAG_TYPE_2"
			end
		end
		-- -- To Drum
		if MagTypeDrum and MagType ~= MagTypeDrum then
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeDrum"] = {}
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeDrum"].name = getText("IGUI_GFR_MagTypeDrum")
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeDrum"].icons = getTexture("media/ui/GFR_MagTypeDrum.png")
			ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeDrum"].functions = self.GFRMSimKeyPressMagtype
			if MagType == MagTypeStd then
				ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeDrum"].arguments = "MAG_TYPE_2"
			elseif MagType == MagTypeExt then
				ISFirearmRadialMenu.main["CMagType"].subMenu["MagTypeDrum"].arguments = "MAG_TYPE_1"
			end
		end
	end

	-- Alternate Load - Load with Magazine or Clip
	if Gun:getModData().ClipType and Gun:getModData().MagType then
		if Gun:getModData().MagType ~= "Base.SKSFixedBox" then
			ISFirearmRadialMenu.main["CAltLoad"] = {}
			if MagType == Gun:getModData().MagType then
				ISFirearmRadialMenu.main["CAltLoad"].name = getText("IGUI_GFR_AltLoad")..'\n'..'['..getText("IGUI_GFR_AltLoadMag")..']'
			end
			if MagType == Gun:getModData().ClipType then
				ISFirearmRadialMenu.main["CAltLoad"].name = getText("IGUI_GFR_AltLoad")..'\n'..'['..getText("IGUI_GFR_AltLoadClip")..']'
			end
			ISFirearmRadialMenu.main["CAltLoad"].icons = getTexture("media/ui/GFR_AltLoad.png")
			ISFirearmRadialMenu.main["CAltLoad"].functions = self.GFRMSimKeyPress
			ISFirearmRadialMenu.main["CAltLoad"].arguments = "ALT_LOAD"
		end
	end

	-- Launcher Trajectory Up/Down
	if (isFlamer(Gun) or isLauncher(Gun)) and
		(not string.find(GunType, "P21_Chainsaw")) and
		(not string.find(GunType, "WD_Flame")) then
			ISFirearmRadialMenu.main["CRangeUp"] = {}
			ISFirearmRadialMenu.main["CRangeUp"].name = getText("IGUI_GFR_RangeUp") .. '\n' .. '[' .. GunTrajectory .. ']'
			ISFirearmRadialMenu.main["CRangeUp"].icons = getTexture("media/ui/GFR_RangeUp.png")
			ISFirearmRadialMenu.main["CRangeUp"].functions = self.GFRMSimKeyPress
			ISFirearmRadialMenu.main["CRangeUp"].arguments = "TRAJECTORY_UP"
			ISFirearmRadialMenu.main["CRangeDown"] = {}
			ISFirearmRadialMenu.main["CRangeDown"].name = getText("IGUI_GFR_RangeDown") .. '\n' .. '[' .. GunTrajectory .. ']'
			ISFirearmRadialMenu.main["CRangeDown"].icons = getTexture("media/ui/GFR_RangeDown.png")
			ISFirearmRadialMenu.main["CRangeDown"].functions = self.GFRMSimKeyPress
			ISFirearmRadialMenu.main["CRangeDown"].arguments = "TRAJECTORY_DOWN"
	
	-- CQB Toggle
	elseif GunisRanged then
		ISFirearmRadialMenu.main["CCQB"] = {}
		ISFirearmRadialMenu.main["CCQB"].icons = getTexture("media/ui/GFR_CQB.png")
		ISFirearmRadialMenu.main["CCQB"].functions = self.GFRMSimKeyPress
		if GunTrajectory ~= "CQB" then
			ISFirearmRadialMenu.main["CCQB"].name = getText("IGUI_GFR_CQB")..'\n'..'['..getText("IGUI_GFR_Off")..']'
			ISFirearmRadialMenu.main["CCQB"].arguments = "TRAJECTORY_DOWN"
		elseif GunTrajectory == "CQB" then
			ISFirearmRadialMenu.main["CCQB"].name = getText("IGUI_GFR_CQB")..'\n'..'['..getText("IGUI_GFR_On")..']'
			ISFirearmRadialMenu.main["CCQB"].arguments = "TRAJECTORY_UP"
		end
	end

	-- Enter Melee Mode or Exit Launcher Mode
	if (GunSling and string.find(GunSling:getType(), "Launcher")) or GunMelee then
		ISFirearmRadialMenu.main["CMeleeLauncher"] = {}
		if GunisRanged then
			ISFirearmRadialMenu.main["CMeleeLauncher"].name = getText("IGUI_GFR_MeleeLauncher")..'\n'..'['..getText("IGUI_GFR_MeleeRanged")..']'
		else
			ISFirearmRadialMenu.main["CMeleeLauncher"].name = getText("IGUI_GFR_MeleeLauncher")..'\n'..'['..getText("IGUI_GFR_MeleeMelee")..']'
		end
		ISFirearmRadialMenu.main["CMeleeLauncher"].icons = getTexture("media/ui/GFR_MeleeLauncher.png")
		ISFirearmRadialMenu.main["CMeleeLauncher"].functions = self.GFRMSimKeyPress
		ISFirearmRadialMenu.main["CMeleeLauncher"].arguments = "MELEE_MODE"
	end

	-- Deploy/Fold Stock, Toggle Bayonet for guns with built in bayonets (SKS)
	if GunFold then
		ISFirearmRadialMenu.main["CFoldStock"] = {}
		ISFirearmRadialMenu.main["CFoldStock"].functions = self.GFRMSimKeyPress
		ISFirearmRadialMenu.main["CFoldStock"].arguments = "FOLD_STOCK"
		if string.find(GunType, "Fold") or string.find(GunFold, "Stock") then
			ISFirearmRadialMenu.main["CFoldStock"].name = getText("IGUI_GFR_StockToggle")..'\n'..'['..getText("IGUI_GFR_StockFolded")..']'
			ISFirearmRadialMenu.main["CFoldStock"].icons = getTexture("media/ui/GFR_StockToggle.png")
		elseif string.find(GunType, "Stock") or string.find(GunFold, "Fold") then
			ISFirearmRadialMenu.main["CFoldStock"].name = getText("IGUI_GFR_StockToggle")..'\n'..'['..getText("IGUI_GFR_StockExtended")..']'
			ISFirearmRadialMenu.main["CFoldStock"].icons = getTexture("media/ui/GFR_StockToggle.png")
		else 
			ISFirearmRadialMenu.main["CFoldStock"].name = getText("IGUI_GFR_StockBayonet")
			ISFirearmRadialMenu.main["CFoldStock"].icons = getTexture("media/ui/GFR_StockBayonet.png")
		end
	end

	-- Cycle Available Grenades (Launcher)
	if (GunSling and string.find(GunSling:getType(), "Launcher")) or (GunIntegral and GunIntegral == "Launcher") or isLauncher(Gun) then
		ISFirearmRadialMenu.main["CCycleGrenade"] = {}
		if GunAmmoType == "Base.40HERound" then
			ISFirearmRadialMenu.main["CCycleGrenade"].name = getText("IGUI_GFR_CycleGrenade")..'\n'..'['..getText("IGUI_GFR_CycleGrenadeHE")..']'
		elseif GunAmmoType == "Base.40INCRound" then
			ISFirearmRadialMenu.main["CCycleGrenade"].name = getText("IGUI_GFR_CycleGrenade")..'\n'..'['..getText("IGUI_GFR_CycleGrenadeINC")..']'
		else
			ISFirearmRadialMenu.main["CCycleGrenade"].name = getText("IGUI_GFR_CycleGrenade")
		end
		ISFirearmRadialMenu.main["CCycleGrenade"].icons = getTexture("media/ui/GFR_CycleGrenade.png")
		ISFirearmRadialMenu.main["CCycleGrenade"].functions = self.GFRMSimKeyPress
		ISFirearmRadialMenu.main["CCycleGrenade"].arguments = "AMMO_TYPE_2"
	end

	-- Cycle Available Calibers
	if Gun:getModData().CompAmmo and not ((GunSling and string.find(GunSling:getType(), "Launcher")) or isLauncher(Gun)) then
		local Caliber = getScriptManager():FindItem(GunAmmoType):getDisplayName()
		Caliber = Caliber:gsub(" Round", "")
		ISFirearmRadialMenu.main["CCycleCaliber"] = {}
		ISFirearmRadialMenu.main["CCycleCaliber"].name = getText("IGUI_GFR_CycleCaliber")..'\n'..'['..Caliber..']'
		ISFirearmRadialMenu.main["CCycleCaliber"].icons = getTexture("media/ui/GFR_CycleCaliber.png")
		ISFirearmRadialMenu.main["CCycleCaliber"].functions = self.GFRMSimKeyPress
		ISFirearmRadialMenu.main["CCycleCaliber"].arguments = "AMMO_TYPE_1"
	end

	-- Cycle Available Fire Modes
	if Gun:getFireModePossibilities() then
		ISFirearmRadialMenu.main["CCycleFireMode"] = {}
		if Gun:getFireMode() then
			ISFirearmRadialMenu.main["CCycleFireMode"].name = getText("IGUI_GFR_CycleFiremode")..'\n'..'['..Gun:getFireMode()..']'
		else
			ISFirearmRadialMenu.main["CCycleFireMode"].name = getText("IGUI_GFR_CycleFiremode")
		end
		ISFirearmRadialMenu.main["CCycleFireMode"].icons = getTexture("media/ui/GFR_CycleFiremode.png")
		ISFirearmRadialMenu.main["CCycleFireMode"].functions = self.GFRMSimKeyPress
		ISFirearmRadialMenu.main["CCycleFireMode"].arguments = "SELECT_FIRE"
	end

	-- Toggle Attached Gun Light
	if GunStock and (string.find(GunStock:getType(), "Light") or string.find(GunStock:getType(), "PEQ") or string.find(GunStock:getType(), "DVAL")) then
		ISFirearmRadialMenu.main["CGunLight"] = {}
		ISFirearmRadialMenu.main["CGunLight"].functions = self.GFRMSimKeyPress
		ISFirearmRadialMenu.main["CGunLight"].arguments = "WEAPON_LIGHT"
		if GunLight ~= true then
			ISFirearmRadialMenu.main["CGunLight"].name = getText("IGUI_GFR_GunLight")..'\n'..'['..getText("IGUI_GFR_Off")..']'
			ISFirearmRadialMenu.main["CGunLight"].icons = getTexture("media/ui/GFR_GunLightOn.png")
		else
			ISFirearmRadialMenu.main["CGunLight"].name = getText("IGUI_GFR_GunLight")..'\n'..'['..getText("IGUI_GFR_On")..']'
			ISFirearmRadialMenu.main["CGunLight"].icons = getTexture("media/ui/GFR_GunLightOff.png")
		end
	end

	if not submenu then -- Main menu buttons
		for i,v in pairs(ISFirearmRadialMenu.main) do
			if v.subMenu then
				menu:addSlice(v.name, v.icons, self.fillMenu, self, i) -- Button with submenu
			else 
				menu:addSlice(v.name, v.icons, v.functions, self, v.arguments)  -- Button without submenu
			end
		end
	else -- Submenu Buttons
		menu:clear()
		for _,v in pairs(ISFirearmRadialMenu.main[submenu].subMenu) do
			menu:addSlice(v.name, v.icons, v.functions, self, v.arguments)
		end
		menu:addSlice(getText("IGUI_Emote_Back"), getTexture("media/ui/emotes/back.png"), self.fillMenu, self)
	end
	self:display()
end

function ISFirearmRadialMenu:GFRMSimKeyPress(arguments)
	if arguments == nil then return end
	triggerEvent('OnKeyPressed', getCore():getKey(arguments))
end

-- Timed action to sequence Eject Magazine > Change Magazine Type
GFRMChangeMagtype = ISBaseTimedAction:derive("GFRMChangeMagtype");
function GFRMChangeMagtype:new(frm, arguments)
	local o = ISBaseTimedAction.new(self, character)
	o.frm = frm
    o.character = frm.character
	o.stopOnWalk = false
	o.stopOnRun = true
	o.stopOnAim = false
	o.maxTime = 1
	o.useProgressBar = false
	o.arguments = arguments
	return o
end
function GFRMChangeMagtype:isValid() return true end;
function GFRMChangeMagtype:stop() ISBaseTimedAction.stop(self) end;
function GFRMChangeMagtype:start() end;
function GFRMChangeMagtype:perform()
	triggerEvent('OnKeyPressed', getCore():getKey(self.arguments))
	ISBaseTimedAction.perform(self)
end

function ISFirearmRadialMenu:GFRMSimKeyPressMagtype(arguments)
	if arguments == nil then return end
	local Gun = self:getWeapon()
	if (Gun:isContainsClip() == true) and (Gun:getMagazineType() ~= "Base.Fixed") then
		ISTimedActionQueue.add(ISEjectMagazine:new(self.character, Gun))
	end
	ISTimedActionQueue.add(GFRMChangeMagtype:new(self, arguments))
end

function ISFirearmRadialMenu.checkWeapon(playerObj)
	local weapon = playerObj:getPrimaryHandItem()
	if not weapon then return false end
	if not instanceof(weapon, "HandWeapon") then return false end
	if not weapon:isAimedFirearm() then return false end 		-- GunFighter Radial Menu -- Changed weapon:isRanged() to weapon:isAimedFirearm() to enable for Melee Mode.
	return true
end

Events.OnGameStart.Add(OnGameStart)